/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.stream;

import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.x509.RevokedCertificate;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.stream.CRLListener;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class RevokedCertificatesCRLListener
implements CRLListener {
    private X509Certificate[] a;
    private PublicKey b;
    private Hashtable c;
    private int d;
    private AlgorithmID e;
    private Name f;
    private Name g;
    private Date h;
    private Date i;
    private boolean j;
    private Hashtable k;
    private X509Extensions l;
    private AlgorithmID m;
    private byte[] n;
    private boolean o;
    private byte[][] p;

    public RevokedCertificatesCRLListener(X509Certificate[] x509CertificateArray, PublicKey publicKey) {
        this.a = x509CertificateArray;
        this.c = new Hashtable(2);
        this.p = new byte[x509CertificateArray.length][];
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            Name name = (Name)x509CertificateArray[i2].getIssuerDN();
            Hashtable<BigInteger, X509Certificate> hashtable = (Hashtable<BigInteger, X509Certificate>)this.c.get(name);
            if (hashtable == null) {
                hashtable = new Hashtable<BigInteger, X509Certificate>(256);
                this.c.put(name, hashtable);
            }
            BigInteger bigInteger = x509CertificateArray[i2].getSerialNumber();
            hashtable.put(bigInteger, x509CertificateArray[i2]);
            this.p[i2] = bigInteger.toByteArray();
        }
        this.b = publicKey;
        this.k = new Hashtable();
    }

    public Signature getSignature(AlgorithmID algorithmID) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature;
        if (this.b != null) {
            signature = algorithmID.getSignatureInstance("IAIK");
            signature.initVerify(this.b);
            this.e = algorithmID;
        } else {
            signature = null;
        }
        return signature;
    }

    public void header(int n2, Name name, Date date, Date date2) {
        this.d = n2;
        this.g = this.f = name;
        this.h = date;
        this.i = date2;
    }

    public void revokedCertificate(byte[] byArray, int n2, int n3, int n4, int n5) throws CRLException, X509ExtensionException {
        try {
            for (int i2 = 0; i2 < this.p.length; ++i2) {
                if (this.p[i2].length != n5 || !CryptoUtils.equalsBlock(this.p[i2], 0, byArray, n4, n5)) continue;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                RevokedCertificate revokedCertificate = new RevokedCertificate(DerCoder.decode(byArray2));
                this.revokedCertificate(revokedCertificate);
                return;
            }
        }
        catch (CodingException codingException) {
            throw new CRLException("CRL entry decoding error: " + codingException);
        }
    }

    public void revokedCertificate(RevokedCertificate revokedCertificate) throws CRLException, X509ExtensionException {
        ASN1Type aSN1Type;
        Object object;
        CertificateIssuer certificateIssuer = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
        if (certificateIssuer != null) {
            object = null;
            aSN1Type = certificateIssuer.getIssuer();
            Enumeration enumeration = aSN1Type.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                object = (Name)generalName.getName();
                break;
            }
            if (object == null) {
                throw new X509ExtensionException("CertificateIssuer extension does not contain a directoryName.");
            }
            this.g = object;
            this.j = true;
        }
        if ((object = (Hashtable)this.c.get(this.g)) != null && (aSN1Type = (X509Certificate)((Hashtable)object).get(revokedCertificate.getSerialNumber())) != null) {
            this.k.put(aSN1Type, revokedCertificate);
        }
    }

    public void extensions(X509Extensions x509Extensions) {
        this.l = x509Extensions;
    }

    public void signature(AlgorithmID algorithmID, byte[] byArray, boolean bl) throws CRLException {
        this.m = algorithmID;
        this.n = byArray;
        this.o = bl;
    }

    public Hashtable getRevokedCertificates() {
        return this.k;
    }

    public X509Certificate[] getConsideredCertificates() {
        return this.a;
    }

    public X509Extensions getExtensions() {
        return this.l;
    }

    public boolean isIndirect() {
        return this.j;
    }

    public Name getIssuer() {
        return this.f;
    }

    public PublicKey getIssuerKey() {
        return this.b;
    }

    public Date getNextUpdate() {
        return this.i;
    }

    public AlgorithmID getSignature() {
        return this.m;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.e;
    }

    public byte[] getSignatureValue() {
        return this.n;
    }

    public Date getThisUpdate() {
        return this.h;
    }

    public boolean isVerified() {
        return this.o;
    }

    public int getVersion() {
        return this.d;
    }
}

