/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.mac;

import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.filter.impl.enc.WrapInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HMACAlgorithmParameter
extends AlgorithmParametersSpi {
    private int b;
    static Class a;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof HMACParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        this.b = ((HMACParameterSpec)algorithmParameterSpec).getOutputLength();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        Document document;
        WrapInputStream wrapInputStream = new WrapInputStream(new ByteArrayInputStream(byArray), null);
        try {
            document = DOMUtils.parse(wrapInputStream, null, null, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Failed to parse HMAC parameter. " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException("Failed to parse HMAC parameter. " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new IOException("Failed to parse HMAC parameter. " + iOException.getMessage());
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
        if (nodeList.getLength() == 1) {
            String string = DOMUtils.getAllTextFromChildren((Element)nodeList.item(0));
            try {
                this.b = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Failed to parse HMAC parameter. " + numberFormatException.getMessage());
            }
        } else {
            throw new IOException("Failed to parse HMAC parameter.");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!"XML".equalsIgnoreCase(string)) {
            throw new IOException("Encoding format '" + string + "' is not supported.");
        }
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(a == null ? (a = HMACAlgorithmParameter.a("javax.xml.crypto.dsig.spec.HMACParameterSpec")) : a)) {
            return new HMACParameterSpec(this.b);
        }
        throw new InvalidParameterSpecException();
    }

    protected byte[] engineGetEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        outputStreamWriter.write("<HMACOutputLength xmlns=\"http://www.w3.org/2000/09/xmldsig#\">" + this.b + "</HMACOutputLength>");
        ((Writer)outputStreamWriter).flush();
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if ("XML".equalsIgnoreCase(string)) {
            return this.engineGetEncoded();
        }
        throw new IOException("Encoding format '" + string + "' is not supported.");
    }

    protected String engineToString() {
        return super.toString() + "OutputLength=" + this.b;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

