/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.security.ec.common.ECParameterSpec;
import iaik.security.ec.common.ECPublicKey;
import iaik.security.ec.common.ECStandardizedParameterFactory;
import iaik.security.ec.common.EllipticCurve;
import iaik.security.ec.errorhandling.InvalidCurveException;
import iaik.security.ec.errorhandling.InvalidCurveParameterSpecException;
import iaik.security.ec.math.field.BinaryField;
import iaik.security.ec.math.field.BinaryFieldByIrreducibleFactory;
import iaik.security.ec.math.field.Field;
import iaik.security.ec.math.field.FieldElement;
import iaik.security.ec.math.field.FieldTypes;
import iaik.security.ec.math.field.PrimeField;
import iaik.security.ec.math.field.PrimeFieldByPrimeFactory;
import iaik.utils.Util;
import iaik.xml.crypto.dsig.keyinfo.ECDSAKeyValueTypeImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.ECPoint;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EccelerateDSAKeyValueImpl
extends ECDSAKeyValueTypeImpl {
    public static final int PRIMEFIELD_TYPE = 1;
    public static final int BINARYFIELD_TYPE = 2;
    public static final String xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
    static Class h;

    public EccelerateDSAKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public EccelerateDSAKeyValueImpl(PublicKey publicKey) {
        super(publicKey);
        if (!(publicKey instanceof ECPublicKey)) {
            throw new IllegalArgumentException("Argument 'ecdsaPublicKey' must be of type '" + (h == null ? (h = EccelerateDSAKeyValueImpl.b("iaik.security.ec.common.ECPublicKey")) : h).getName() + "'.");
        }
    }

    public String getLocalName() {
        return "ECDSAKeyValue";
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmldsig-more#";
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3;
        Element element;
        Object object;
        Object object2;
        Node node4 = super.marshal(dOMCryptoContext, node, node2);
        dOMCryptoContext.putNamespacePrefix(xsiNS, "xsi");
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix());
        String string2 = this.getNamespace();
        ECPublicKey eCPublicKey = (ECPublicKey)this.publicKey_;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        Field field = ellipticCurve.getField();
        FieldTypes fieldTypes = field.getFieldType();
        if (eCParameterSpec != null) {
            object2 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "DomainParameters"));
            object = eCParameterSpec.getOID();
            if (object != null) {
                element = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "NamedCurve"));
                node3 = document.createAttributeNS("", "URN");
                node3.setValue("urn:oid:" + eCParameterSpec.getOID());
                element.setAttributeNodeNS((Attr)node3);
                object2.appendChild(element);
                node4.appendChild((Node)object2);
            } else {
                Element element2;
                Element element3;
                Element element4;
                Object object3;
                Object object4;
                Object object5;
                element = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "ExplicitParams"));
                node3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "FieldParams"));
                if (fieldTypes == FieldTypes.PRIME_FIELD) {
                    object5 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "P"));
                    DOMUtils.addBigIntegerToElement((Element)object5, field.getCardinality());
                    node3.appendChild((Node)object5);
                    node3.setAttributeNS(xsiNS, "xsi:type", "PrimeFieldParamsType");
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                } else if (fieldTypes == FieldTypes.BINARY_FIELD) {
                    object5 = (BinaryField)field;
                    object4 = object5.getReductionPolynomial();
                    int n2 = object5.getM();
                    object3 = object5.getMidTermsOfReductionPolynomial();
                    int n3 = 2 + ((int[])object3).length;
                    switch (n3) {
                        case 3: {
                            element4 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element4, Integer.toString(object5.getM()));
                            node3.appendChild(element4);
                            element3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "K"));
                            DOMUtils.addTextToElement(element3, Integer.toString(object3[0], 10));
                            node3.appendChild(element3);
                            node3.setAttributeNS(xsiNS, "xsi:type", "TnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                            break;
                        }
                        case 5: {
                            element4 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "M"));
                            DOMUtils.addTextToElement(element4, Integer.toString(object5.getM()));
                            node3.appendChild(element4);
                            element2 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "K1"));
                            DOMUtils.addTextToElement(element2, Integer.toString(object3[0], 10));
                            node3.appendChild(element2);
                            Element element5 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "K2"));
                            DOMUtils.addTextToElement(element5, Integer.toString(object3[1], 10));
                            node3.appendChild(element5);
                            Element element6 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "K3"));
                            DOMUtils.addTextToElement(element6, Integer.toString(object3[2], 10));
                            node3.appendChild(element6);
                            node3.setAttributeNS(xsiNS, "xsi:type", "PnBFieldParamsType");
                            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
                        }
                    }
                } else {
                    throw new MarshalException("Field type not supported!");
                }
                element.appendChild(node3);
                object5 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "CurveParams"));
                object4 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "A"));
                object4.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? ellipticCurve.getA().toString(10) : EccelerateDSAKeyValueImpl.d(ellipticCurve.getA().toString(16)));
                object5.appendChild((Node)object4);
                Element element7 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "B"));
                element7.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? ellipticCurve.getB().toString(10) : EccelerateDSAKeyValueImpl.d(ellipticCurve.getB().toString(16)));
                object5.appendChild(element7);
                if (eCParameterSpec.getCurve().getSeed() != null) {
                    object3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "Seed"));
                    object3.appendChild(document.createTextNode(EccelerateDSAKeyValueImpl.d(Util.toString((byte[])eCParameterSpec.getCurve().getSeed()))));
                    object5.appendChild((Node)object3);
                }
                element.appendChild((Node)object5);
                object3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "BasePointParams"));
                ECPoint eCPoint = eCParameterSpec.getGenerator();
                element4 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "BasePoint"));
                object3.appendChild(element4);
                if (eCPoint != ECPoint.POINT_INFINITY) {
                    element3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "X"));
                    element2 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "Y"));
                    element4.appendChild(element3);
                    element4.appendChild(element2);
                    element3.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? eCPoint.getAffineX().toString(10) : EccelerateDSAKeyValueImpl.d(eCParameterSpec.getGenerator().getAffineX().toString(16)));
                    element3.setAttributeNS(xsiNS, "xsi:type", fieldTypes == FieldTypes.PRIME_FIELD ? EccelerateDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : EccelerateDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element3, xsiNS);
                    element2.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? eCPoint.getAffineY().toString(10) : EccelerateDSAKeyValueImpl.d(eCParameterSpec.getGenerator().getAffineY().toString(16)));
                    element2.setAttributeNS(xsiNS, "xsi:type", fieldTypes == FieldTypes.PRIME_FIELD ? EccelerateDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : EccelerateDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
                    DOMUtils.createNSDeclAttribute(dOMCryptoContext, element2, xsiNS);
                }
                element3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "Order"));
                object3.appendChild(element3);
                DOMUtils.addBigIntegerToElement(element3, eCParameterSpec.getOrder());
                element2 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "Cofactor"));
                object3.appendChild(element2);
                DOMUtils.addBigIntegerToElement(element2, BigInteger.valueOf(eCParameterSpec.getCofactor()));
                element.appendChild((Node)object3);
                object2.appendChild(element);
                node4.appendChild((Node)object2);
            }
        }
        object2 = eCPublicKey.getW();
        object = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "PublicKey"));
        if (object2 != ECPoint.POINT_INFINITY) {
            element = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "X"));
            node3 = document.createElementNS(string2, EccelerateDSAKeyValueImpl.getQualifiedName(string, "Y"));
            element.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? ((ECPoint)object2).getAffineX().toString(10) : EccelerateDSAKeyValueImpl.d(((ECPoint)object2).getAffineX().toString(16)));
            element.setAttributeNS(xsiNS, "xsi:type", fieldTypes == FieldTypes.PRIME_FIELD ? EccelerateDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : EccelerateDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, xsiNS);
            node3.setAttributeNS("", "Value", fieldTypes == FieldTypes.PRIME_FIELD ? ((ECPoint)object2).getAffineY().toString(10) : EccelerateDSAKeyValueImpl.d(((ECPoint)object2).getAffineY().toString(16)));
            node3.setAttributeNS(xsiNS, "xsi:type", fieldTypes == FieldTypes.PRIME_FIELD ? EccelerateDSAKeyValueImpl.getQualifiedName(string, "PrimeFieldElemType") : EccelerateDSAKeyValueImpl.getQualifiedName(string, "CharTwoFieldElemType"));
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, (Element)node3, xsiNS);
            object.appendChild(element);
            object.appendChild(node3);
        }
        node4.appendChild((Node)object);
        dOMCryptoContext.putNamespacePrefix(xsiNS, null);
        return node4;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        ECParameterSpec eCParameterSpec;
        Object object2;
        if (nodeList == null) {
            return;
        }
        String string = this.getNamespace();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Element element = EccelerateDSAKeyValueImpl.a((Element)this.getNode(), string, "DomainParameters", 1);
        if (element == null) {
            throw new MarshalException("Domain parameters must not be implicit.");
        }
        Element element2 = EccelerateDSAKeyValueImpl.a(element, string, "NamedCurve", 1);
        if (element2 != null) {
            try {
                object2 = new URI(element2.getAttributeNS(null, "URN"));
                eCParameterSpec = ECStandardizedParameterFactory.getParametersByOID((String)((URI)object2).getPath().substring(4));
            }
            catch (URIException uRIException) {
                throw new MarshalException("Error when producing a URI from OID: ", uRIException);
            }
        }
        object2 = EccelerateDSAKeyValueImpl.a(element, string, "ExplicitParams", 1);
        Element element3 = EccelerateDSAKeyValueImpl.a((Element)object2, string, "FieldParams", 1);
        Object object3 = EccelerateDSAKeyValueImpl.a((Element)object2, string, "CurveParams", 1);
        Element element4 = EccelerateDSAKeyValueImpl.a((Element)object2, string, "BasePointParams", 1);
        String string2 = dOMCryptoContext.getNamespacePrefix(string, null);
        Object object4 = null;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        NodeList nodeList2 = element3.getChildNodes();
        for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
            object = nodeList2.item(i2);
            if (object.getNodeType() != 1) continue;
            if (object.getLocalName().equals("P")) {
                if (n2 != 0) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n2 = 1;
                object4 = new BigInteger(EccelerateDSAKeyValueImpl.b(element3, string, "P", 1), 10);
                continue;
            }
            if (object.getLocalName().equals("M")) {
                if (n2 != 0) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n2 = 2;
                n3 = Integer.parseInt(EccelerateDSAKeyValueImpl.b(element3, string, "M", 1));
                continue;
            }
            if (object.getLocalName().equals("K")) {
                if (n2 != 2) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n2 = 3;
                n4 = Integer.parseInt(EccelerateDSAKeyValueImpl.b(element3, string, "K", 1));
                continue;
            }
            if (object.getLocalName().equals("K1")) {
                if (n2 != 2) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n2 = 4;
                n5 = Integer.parseInt(EccelerateDSAKeyValueImpl.b(element3, string, "K1", 1));
                continue;
            }
            if (object.getLocalName().equals("K2")) {
                if (n2 != 4) {
                    throw new MarshalException("Illegal FieldParameters supplied");
                }
                n2 = 4;
                n6 = Integer.parseInt(EccelerateDSAKeyValueImpl.b(element3, string, "K2", 1));
                continue;
            }
            if (!object.getLocalName().equals("K3")) continue;
            if (n2 != 4) {
                throw new MarshalException("Illegal FieldParameters supplied");
            }
            n2 = 4;
            n7 = Integer.parseInt(EccelerateDSAKeyValueImpl.b(element3, string, "K3", 1));
        }
        if (n2 == 0) {
            throw new MarshalException("No valid FieldParams found!");
        }
        Element element5 = EccelerateDSAKeyValueImpl.a((Element)object3, string, "A", 1);
        object = element5.getAttributeNS(null, "Value");
        Element element6 = EccelerateDSAKeyValueImpl.a((Element)object3, string, "B", 1);
        String string3 = element6.getAttributeNS(null, "Value");
        String string4 = EccelerateDSAKeyValueImpl.b((Element)object3, string, "Seed", 1);
        BigInteger bigInteger = string4 != null ? new BigInteger(string4, 10) : null;
        Element element7 = EccelerateDSAKeyValueImpl.a(element4, string, "BasePoint", 1);
        Element element8 = EccelerateDSAKeyValueImpl.a(element7, string, "X", 1);
        String string5 = element8.getAttributeNS(null, "Value");
        Element element9 = EccelerateDSAKeyValueImpl.a(element7, string, "Y", 1);
        String string6 = element9.getAttributeNS(null, "Value");
        String string7 = EccelerateDSAKeyValueImpl.b(element4, string, "Order", 1);
        BigInteger bigInteger2 = new BigInteger(string7, 10);
        String string8 = EccelerateDSAKeyValueImpl.b(element4, string, "Cofactor", 1);
        int n8 = Integer.parseInt(string8, 10);
        try {
            if (n2 == 1) {
                BigInteger bigInteger3 = new BigInteger((String)object, 10);
                BigInteger bigInteger4 = new BigInteger(string3, 10);
                BigInteger bigInteger5 = new BigInteger(string5, 10);
                BigInteger bigInteger6 = new BigInteger(string6, 10);
                ECPoint eCPoint = new ECPoint(bigInteger5, bigInteger6);
                EllipticCurve ellipticCurve = EllipticCurve.getCurve((Field)PrimeFieldByPrimeFactory.getField((BigInteger)object4), (BigInteger)bigInteger3, (BigInteger)bigInteger4, (BigInteger)bigInteger2, (byte[])bigInteger.toByteArray());
                eCParameterSpec = ECParameterSpec.getParameterSpec((EllipticCurve)ellipticCurve, (ECPoint)eCPoint, (BigInteger)bigInteger2, (int)n8, null, null);
            } else {
                BigInteger bigInteger7 = BigInteger.ZERO.setBit(n3).setBit(0);
                if (n2 == 3) {
                    bigInteger7.setBit(n4);
                } else {
                    bigInteger7.setBit(n5);
                    bigInteger7.setBit(n6);
                    bigInteger7.setBit(n7);
                }
                BigInteger bigInteger8 = new BigInteger((String)object, 8);
                BigInteger bigInteger9 = new BigInteger(string3, 8);
                ECPoint eCPoint = new ECPoint(new BigInteger(string5, 8), new BigInteger(string6, 8));
                EllipticCurve ellipticCurve = EllipticCurve.getCurve((Field)BinaryFieldByIrreducibleFactory.getField((BigInteger)bigInteger7), (BigInteger)bigInteger8, (BigInteger)bigInteger9, (BigInteger)bigInteger2, (byte[])bigInteger.toByteArray());
                eCParameterSpec = ECParameterSpec.getParameterSpec((EllipticCurve)ellipticCurve, (ECPoint)eCPoint, (BigInteger)bigInteger2, (int)n8, null, null);
            }
        }
        catch (InvalidCurveException invalidCurveException) {
            throw new MarshalException("Invalid curve!", invalidCurveException);
        }
        catch (InvalidCurveParameterSpecException invalidCurveParameterSpecException) {
            throw new MarshalException("Invalid curve parameters!", invalidCurveParameterSpecException);
        }
        object2 = EccelerateDSAKeyValueImpl.a((Element)this.getNode(), string, "PublicKey", 1);
        element3 = EccelerateDSAKeyValueImpl.a((Element)object2, string, "X", 1);
        object3 = element3.getAttributeNS(null, "Value");
        element4 = EccelerateDSAKeyValueImpl.a((Element)object2, string, "Y", 1);
        string2 = element4.getAttributeNS(null, "Value");
        try {
            FieldElement fieldElement;
            FieldElement fieldElement2;
            int n9;
            object4 = eCParameterSpec;
            EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
            Field field = ellipticCurve.getField();
            int n10 = 1;
            int n11 = 2;
            int n12 = n9 = eCParameterSpec.getCurve().getField().getFieldType() == FieldTypes.PRIME_FIELD ? n10 : n11;
            if (n9 == n10) {
                PrimeField primeField = (PrimeField)field;
                fieldElement2 = primeField.newElement(new BigInteger((String)object3, 10));
                fieldElement = primeField.newElement(new BigInteger(string2, 10));
            } else {
                fieldElement2 = field.newElement(EccelerateDSAKeyValueImpl.e((String)object3));
                fieldElement = field.newElement(EccelerateDSAKeyValueImpl.e(string2));
            }
            ECPoint eCPoint = new ECPoint(fieldElement2.toBigInteger(), fieldElement.toBigInteger());
            ECPublicKey eCPublicKey = new ECPublicKey(object4, eCPoint);
            this.publicKey_ = eCPublicKey;
        }
        catch (Exception exception) {
            throw new MarshalException("An error occured during Marshaling the ECDSAKeyValue");
        }
    }

    private static String d(String string) {
        return string.length() % 2 != 0 ? "0" + string : string;
    }

    private static Element a(Element element, String string, String string2, int n2) {
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() < n2) {
            return null;
        }
        return (Element)nodeList.item(n2 - 1);
    }

    private static String b(Element element, String string, String string2, int n2) {
        Element element2 = EccelerateDSAKeyValueImpl.a(element, string, string2, n2);
        if (element2 == null) {
            return null;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }

    private static byte[] e(String string) {
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.length() - (i2 + 1) * 2;
            byArray[n2 - i2 - 1] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
        }
        return byArray;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

