/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.NoSuchAlgorithmWithCauseException;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.enc.KeySizeImpl;
import iaik.xml.crypto.utils.Nodes;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionMethodImpl
extends AlgorithmMethodImpl
implements EncryptionMethod {
    protected Cipher cipher_;
    protected KeySizeImpl keySize_;
    static Class h;

    public EncryptionMethodImpl(String string, Integer n2, EncryptionMethodParameterSpec encryptionMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(string, encryptionMethodParameterSpec);
        if (n2 != null) {
            this.keySize_ = new KeySizeImpl(n2);
        }
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            this.getAlgorithmInstanceUncaught(null);
        }
    }

    public EncryptionMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.algorithm_ == null) {
            throw new MarshalException("The content of element '" + node.getLocalName() + "' is not complete.");
        }
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            try {
                this.getAlgorithmInstanceUncaught(null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MarshalException(noSuchAlgorithmException);
            }
        }
    }

    protected void getAlgorithmInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException {
        String string = URLEncoder.encode(this.algorithm_.toString());
        Provider provider = XSecProvider.getDelegationProvider("Cipher." + string, purpose);
        try {
            if (provider != null) {
                try {
                    this.cipher_ = Cipher.getInstance(string, provider);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    try {
                        this.cipher_ = Cipher.getInstance(string, provider.getName());
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        throw new NoSuchAlgorithmWithCauseException("Delegation provider not registered, any more.", noSuchProviderException);
                    }
                }
            }
            if (this.cipher_ == null) {
                this.cipher_ = Cipher.getInstance(string);
            }
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmWithCauseException("No such padding.", noSuchPaddingException);
        }
        super.getParamInstanceUncaught(purpose);
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(this.getParameterSpecClass());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new NoSuchAlgorithmWithCauseException("Invalid parameter spec.", invalidParameterSpecException);
            }
        }
    }

    public String getLocalName() {
        return "EncryptionMethod";
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public Integer getKeySize() {
        return this.keySize_ != null ? new Integer(this.keySize_.getKeySize()) : null;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() == 1 && "KeySize".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI())) {
                DOMStructure dOMStructure = EncryptionMethodImpl.getInstance(node, dOMCryptoContext);
                if (dOMStructure == null) continue;
                this.putChildStructure(dOMStructure);
                continue;
            }
            arrayList.add(node);
        }
        super.unmarshalStructures(Nodes.nodeList(arrayList), dOMCryptoContext);
    }

    protected List getChildStructures() {
        ArrayList<KeySizeImpl> arrayList = new ArrayList<KeySizeImpl>();
        if (this.keySize_ != null) {
            arrayList.add(this.keySize_);
        }
        arrayList.addAll(super.getChildStructures());
        return arrayList;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof KeySizeImpl) {
            this.keySize_ = (KeySizeImpl)dOMStructure;
        }
    }

    public byte[] wrapKey(Key key, Key key2) throws XMLEncryptionException {
        if (this.cipher_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.ENCRYPT);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }
        try {
            this.cipher_.init(3, key, this.spec_);
            return this.cipher_.wrap(key2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException(illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException(illegalBlockSizeException);
        }
    }

    public Key unwrapKey(Key key, byte[] byArray, String string, int n2) throws XMLEncryptionException {
        if (this.cipher_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.DECRYPT);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }
        try {
            this.cipher_.init(4, key, this.spec_);
            return this.cipher_.unwrap(byArray, string, n2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException(illegalStateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException(noSuchAlgorithmException);
        }
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        if (this.cipher_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.DECRYPT);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }
        try {
            this.cipher_.init(2, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherInputStream(inputStream, this.cipher_);
    }

    public InputStream encrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        if (this.cipher_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.ENCRYPT);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }
        try {
            this.cipher_.init(1, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherInputStream(inputStream, this.cipher_);
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws XMLEncryptionException {
        if (this.cipher_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.CipherPurpose.ENCRYPT);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLEncryptionException(noSuchAlgorithmException);
            }
        }
        try {
            this.cipher_.init(1, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherOutputStream(outputStream, this.cipher_);
    }

    protected Class getParameterSpecClass() {
        return h == null ? (h = EncryptionMethodImpl.b("javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec")) : h;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

