/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc.keyinfo;

import iaik.xml.crypto.EccProviderAdapter;
import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import iaik.xml.crypto.enc.keyinfo.KANonceImpl;
import iaik.xml.crypto.enc.keyinfo.a;
import iaik.xml.crypto.enc.keyinfo.b;
import iaik.xml.crypto.enc.keyinfo.c;
import iaik.xml.crypto.enc.keyinfo.d;
import iaik.xml.crypto.enc.spec.DHKeyAgreementParameterSpec;
import iaik.xml.crypto.utils.Nodes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.spec.AgreementMethodParameterSpec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AgreementMethodImpl
extends AlgorithmMethodImpl
implements AgreementMethod {
    protected KeyInfoImpl originiatorKeyInfo_;
    protected KeyInfoImpl recipientKeyInfo_;
    protected KANonceImpl kaNonce_;
    protected DigestMethodImpl digestMethod_;
    private PrivateKey i;
    static Class h;

    public AgreementMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.algorithm_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
        try {
            this.getAlgorithmInstanceUncaught(null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException(noSuchAlgorithmException);
        }
    }

    public AgreementMethodImpl(String string, byte[] byArray, KeyInfoImpl keyInfoImpl, KeyInfoImpl keyInfoImpl2, AgreementMethodParameterSpec agreementMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(string, agreementMethodParameterSpec);
        this.originiatorKeyInfo_ = keyInfoImpl;
        if (this.originiatorKeyInfo_ != null) {
            this.originiatorKeyInfo_.setLocalname("OriginatorKeyInfo");
            this.originiatorKeyInfo_.setNamsepace("http://www.w3.org/2001/04/xmlenc#");
        }
        this.recipientKeyInfo_ = keyInfoImpl2;
        if (this.recipientKeyInfo_ != null) {
            this.recipientKeyInfo_.setLocalname("RecipientKeyInfo");
            this.recipientKeyInfo_.setNamsepace("http://www.w3.org/2001/04/xmlenc#");
        }
        if (byArray != null) {
            this.kaNonce_ = new KANonceImpl(byArray);
        }
        if (agreementMethodParameterSpec != null && agreementMethodParameterSpec instanceof DHKeyAgreementParameterSpec) {
            this.digestMethod_ = (DigestMethodImpl)((DHKeyAgreementParameterSpec)agreementMethodParameterSpec).getDigestMethod();
        }
    }

    protected void getAlgorithmInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException {
        super.getParamInstanceUncaught(purpose);
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(this.getParameterSpecClass());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new a(this, invalidParameterSpecException);
            }
        }
    }

    public String getLocalName() {
        return "AgreementMethod";
    }

    public byte[] getKANonce() {
        return this.kaNonce_ != null ? this.kaNonce_.getValue() : null;
    }

    public XMLStructure getOriginatorKeyInfo() {
        return this.originiatorKeyInfo_;
    }

    public XMLStructure getRecipientKeyInfo() {
        return this.recipientKeyInfo_;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() == 1 && "KA-Nonce".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || node.getNodeType() == 1 && "OriginatorKeyInfo".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || node.getNodeType() == 1 && "RecipientKeyInfo".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI())) {
                DOMStructure dOMStructure = AgreementMethodImpl.getInstance(node, dOMCryptoContext);
                if (dOMStructure == null) continue;
                this.putChildStructure(dOMStructure);
                continue;
            }
            arrayList.add(node);
        }
        super.unmarshalStructures(Nodes.nodeList(arrayList), dOMCryptoContext);
    }

    protected List getChildStructures() {
        ArrayList<DOMStructure> arrayList = new ArrayList<DOMStructure>();
        if (this.kaNonce_ != null) {
            arrayList.add(this.kaNonce_);
        }
        if (this.digestMethod_ != null) {
            arrayList.add(this.digestMethod_);
        }
        if (this.originiatorKeyInfo_ != null) {
            arrayList.add(this.originiatorKeyInfo_);
        }
        if (this.recipientKeyInfo_ != null) {
            arrayList.add(this.recipientKeyInfo_);
        }
        return arrayList;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        if (dOMStructure instanceof KANonceImpl) {
            this.kaNonce_ = (KANonceImpl)dOMStructure;
        } else if (dOMStructure instanceof KeyInfoImpl) {
            KeyInfoImpl keyInfoImpl = (KeyInfoImpl)dOMStructure;
            if ("OriginatorKeyInfo".equals(keyInfoImpl.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(keyInfoImpl.getNamespace())) {
                this.originiatorKeyInfo_ = keyInfoImpl;
            } else if ("RecipientKeyInfo".equals(keyInfoImpl.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(keyInfoImpl.getNamespace())) {
                this.recipientKeyInfo_ = keyInfoImpl;
            } else {
                super.putChildStructure(dOMStructure);
            }
        } else {
            super.putChildStructure(dOMStructure);
        }
    }

    public SecretKey generateSecretKey(EncryptionMethod encryptionMethod, PublicKey publicKey) throws XMLEncryptionException {
        SecretKeySpec secretKeySpec = null;
        try {
            Integer n2;
            byte[] byArray = null;
            if (this.i == null) {
                throw new XMLEncryptionException("KeyAgreement has been called without private key!");
            }
            if (EccProviderAdapter.isEcPrivateKey(this.i)) {
                byArray = this.generateAgreedSecret(this.i, publicKey, "ECDH");
            } else if (this.i instanceof DHPrivateKey) {
                byArray = this.generateAgreedSecret(this.i, publicKey, "DH");
            }
            String string = encryptionMethod.getAlgorithm();
            byte[] byArray2 = string.getBytes();
            int n3 = 1;
            byte[] byArray3 = this.getKANonce();
            if (encryptionMethod.getKeySize() != null) {
                n2 = encryptionMethod.getKeySize();
            } else if (AgreementMethodImpl.c(string) != null) {
                n2 = AgreementMethodImpl.c(string);
            } else {
                throw new XMLEncryptionException("No keySize found for the provided algorithm: " + string);
            }
            byte[] byArray4 = n2.toString().getBytes();
            MessageDigest messageDigest = this.digestMethod_ != null ? MessageDigest.getInstance(this.digestMethod_.getAlgorithm()) : MessageDigest.getInstance("SHA-1");
            int n4 = messageDigest.getDigestLength();
            int n5 = n2 / 8;
            byte[] byArray5 = new byte[n5];
            int n6 = 0;
            while (n6 < n5) {
                byte[] byArray6 = AgreementMethodImpl.a(n3);
                messageDigest.update(byArray);
                messageDigest.update(byArray6);
                messageDigest.update(byArray2);
                if (byArray3 != null) {
                    messageDigest.update(byArray3);
                }
                messageDigest.update(byArray4);
                byte[] byArray7 = messageDigest.digest();
                int n7 = n6 >= n5 - n4 ? n5 - n6 : n4;
                System.arraycopy(byArray7, 0, byArray5, n6, n7);
                n6 += n4;
                ++n3;
            }
            secretKeySpec = new SecretKeySpec(byArray5, "AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return secretKeySpec;
    }

    protected byte[] generateAgreedSecret(PrivateKey privateKey, PublicKey publicKey, String string) throws XMLEncryptionException {
        KeyAgreement keyAgreement = null;
        byte[] byArray = null;
        try {
            String string2 = string;
            Provider provider = XSecProvider.getDelegationProvider("KeyAgreement." + string2, null);
            if (provider != null) {
                try {
                    keyAgreement = KeyAgreement.getInstance(string2, provider);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    try {
                        keyAgreement = KeyAgreement.getInstance(string2, provider.getName());
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        throw new b(this, "KeyAgreement." + string2 + " delegation provider not registered, any more.", noSuchProviderException);
                    }
                }
            }
            if (keyAgreement == null) {
                keyAgreement = KeyAgreement.getInstance(string2);
            }
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
            byArray = keyAgreement.generateSecret();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new c(this, noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new d(this, invalidKeyException);
        }
        return byArray;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.i = privateKey;
    }

    private static byte[] a(int n2) {
        String string = new String(AgreementMethodImpl.b(n2)).toUpperCase();
        return string.getBytes();
    }

    private static char[] b(int n2) {
        return new char[]{AgreementMethodImpl.c(n2 >>> 4 & 0xF), AgreementMethodImpl.c(n2 & 0xF)};
    }

    private static char c(int n2) {
        return (char)(n2 < 10 ? 48 + n2 : 65 + (n2 - 10));
    }

    private static Integer c(String string) {
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            return new Integer(128);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            return new Integer(192);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            return new Integer(256);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            return new Integer(192);
        }
        return null;
    }

    protected Class getParameterSpecClass() {
        return h == null ? (h = AgreementMethodImpl.b("javax.xml.crypto.enc.spec.AgreementMethodParameterSpec")) : h;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

