/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class X942DhKeyPairGenerator
extends PKCS11KeyPairGenerator {
    protected Mechanism a() {
        return Mechanism.get((long)48L);
    }

    protected String b() {
        return "DH/X9.42";
    }

    protected iaik.pkcs.pkcs11.objects.Object a(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        pKCS11KeyPairGenerationSpec.getPrivateKeyTemplate().getKeyType().setLongValue(Key.KeyType.X9_42_DH);
        return super.a(pKCS11KeyPairGenerationSpec);
    }

    protected iaik.pkcs.pkcs11.objects.Object b(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        PublicKey publicKey;
        AlgorithmParameterSpec algorithmParameterSpec = pKCS11KeyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DSAParameterSpec) {
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            X942DHPublicKey x942DHPublicKey = new X942DHPublicKey();
            BigInteger bigInteger = dSAParameterSpec.getP();
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger);
            BigInteger bigInteger2 = dSAParameterSpec.getQ();
            byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger2);
            BigInteger bigInteger3 = dSAParameterSpec.getG();
            byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger3);
            x942DHPublicKey.getPrime().setByteArrayValue(byArray);
            x942DHPublicKey.getSubprime().setByteArrayValue(byArray2);
            x942DHPublicKey.getBase().setByteArrayValue(byArray3);
            PublicKey publicKey2 = pKCS11KeyPairGenerationSpec.getPublicKeyTemplate();
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)x942DHPublicKey);
            if (publicKey2 != null) {
                publicKey2.getKeyType().setLongValue(Key.KeyType.X9_42_DH);
                genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)publicKey2);
            }
            publicKey = genericTemplate;
        } else {
            publicKey = pKCS11KeyPairGenerationSpec.getPublicKeyTemplate();
        }
        return publicKey;
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept the given parameters. They must be null or an isntance of DSAParameterSpec, but they are " + algorithmParameterSpec);
        }
    }
}

