/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.random;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class PKCS11RandomSpi
extends SecureRandomSpi
implements PKCS11EngineClass {
    protected TokenManager a;
    protected Session b;
    protected boolean c;
    protected boolean d;
    protected SecureRandom e;

    public PKCS11RandomSpi() {
        int n = IAIKPkcs11.getProviderInstanceCount();
        if (n <= 0) {
            throw new IAIKPkcs11Exception("No instance of IAIKPkcs11 available.");
        }
        this.a = IAIKPkcs11.getCurrentProviderInstance().getTokenManager();
        this.a();
    }

    public PKCS11RandomSpi(TokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.a = tokenManager;
        this.a();
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Token token = this.a.getToken();
            if (token != null) {
                TokenInfo tokenInfo = token.getTokenInfo();
                bl = tokenInfo.isRNG();
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected void a() {
        try {
            boolean bl;
            Token token = this.a.getToken();
            if (token != null) {
                TokenInfo tokenInfo = token.getTokenInfo();
                bl = tokenInfo.isRNG();
            } else {
                bl = false;
            }
            if (!bl) {
                this.d = true;
                this.b();
            } else {
                this.d = false;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Could not get token info: " + (Object)((Object)tokenException));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("Could not instantiate delegate secure random: " + generalSecurityException);
        }
    }

    protected void b() {
        DelegateProvider delegateProvider = this.a != null ? this.a.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.c();
        this.e = delegateProvider.getSecureRandom(string);
        if (this.e == null) {
            throw new IAIKPkcs11Exception("Could not get delegate secure random engine for " + string);
        }
    }

    protected String c() {
        return "SHA1PRNG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"arrayToFill\" must not be null.");
        }
        if (this.d) {
            this.e.nextBytes(byArray);
        } else {
            int n;
            if (!this.c) {
                this.e();
            }
            if ((n = byArray.length) > 0) {
                byte[] byArray2;
                block14: {
                    try {
                        byArray2 = this.b.generateRandom(n);
                    }
                    catch (TokenException tokenException) {
                        if (tokenException instanceof PKCS11Exception) {
                            PKCS11Exception pKCS11Exception = (PKCS11Exception)((Object)tokenException);
                            if (pKCS11Exception.getErrorCode() == 257L) {
                                try {
                                    this.a.makeAuthorizedSession(this.b, null);
                                    byArray2 = this.b.generateRandom(n);
                                    break block14;
                                }
                                catch (TokenException tokenException2) {
                                    throw new IAIKPkcs11Exception(tokenException.toString());
                                }
                            }
                            throw new IAIKPkcs11Exception(tokenException.toString());
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    finally {
                        this.f();
                    }
                }
                System.arraycopy(byArray2, 0, byArray, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineSetSeed(byte[] byArray) {
        block13: {
            if (byArray == null) {
                throw new NullPointerException("Argument \"seedBytes\" must not be null.");
            }
            if (this.d) {
                this.e.setSeed(byArray);
            } else {
                if (!this.c) {
                    this.e();
                }
                try {
                    this.b.seedRandom(byArray);
                }
                catch (TokenException tokenException) {
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)((Object)tokenException);
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.a.makeAuthorizedSession(this.b, null);
                                this.b.seedRandom(byArray);
                                break block13;
                            }
                            catch (TokenException tokenException2) {
                                throw new IAIKPkcs11Exception(tokenException.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
                finally {
                    this.f();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray;
        block13: {
            if (n < 0) {
                throw new IllegalArgumentException("Argument \"numBytes\" must be greater than or equal to zero.");
            }
            if (this.d) {
                byArray = this.e.generateSeed(n);
            } else {
                if (!this.c) {
                    this.e();
                }
                try {
                    byArray = this.b.generateRandom(n);
                }
                catch (TokenException tokenException) {
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)((Object)tokenException);
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.a.makeAuthorizedSession(this.b, null);
                                byArray = this.b.generateRandom(n);
                                break block13;
                            }
                            catch (TokenException tokenException2) {
                                throw new IAIKPkcs11Exception(tokenException.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
                finally {
                    this.f();
                }
            }
        }
        return byArray;
    }

    protected void d() {
        try {
            if (this.b == null) {
                this.b = this.a.getSession(false);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void e() {
        try {
            TokenInfo tokenInfo = this.a.getToken().getTokenInfo();
            if (!tokenInfo.isRNG()) {
                throw new IAIKPkcs11Exception("The PKCS#11 token does not have a random number generator.");
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        this.d();
        this.c = true;
    }

    protected void f() {
        this.c = false;
        this.a.disposeSession(this.b);
        this.b = null;
    }

    protected void finalize() {
        if (this.b != null) {
            this.a.disposeSession(this.b);
        }
        super.finalize();
    }
}

