/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs11.Util;
import java.math.BigInteger;
import java.security.SignatureException;

public abstract class SignatureUtil {
    protected SignatureUtil() {
    }

    public static byte[] RStoASN1(byte[] byArray) {
        byte[] byArray2;
        int n = byArray.length / 2;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray, n, byArray4, 0, n);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = new BigInteger(1, byArray4);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger2));
        try {
            byArray2 = new ASN1((ASN1Object)sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Error encoding r and s: " + codingException.toString());
        }
        return byArray2;
    }

    public static byte[] ASN1toRS(byte[] byArray, int n) {
        byte[] byArray2;
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.toASN1Object().isA(ASN.SEQUENCE)) {
                if (aSN1.countComponents() != 2) {
                    throw new SignatureException("Error decoding r and s. The number of components is not 2.");
                }
            } else {
                throw new SignatureException("Error decoding r and s. The ASN.1 object is no SEQUENCE.");
            }
            ASN1Object aSN1Object = aSN1.getComponentAt(0);
            ASN1Object aSN1Object2 = aSN1.getComponentAt(1);
            BigInteger bigInteger = (BigInteger)aSN1Object.getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object2.getValue();
            byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger);
            byte[] byArray4 = Util.unsignedBigIntergerToByteArray((BigInteger)bigInteger2);
            int n2 = n > 0 ? n : Math.max(byArray3.length, byArray4.length);
            byArray2 = new byte[2 * n2];
            System.arraycopy(byArray3, 0, byArray2, n2 - byArray3.length, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, 2 * n2 - byArray4.length, byArray4.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Error decoding r and s: " + exception.toString());
        }
        return byArray2;
    }
}

