/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;

public class CertInfo {
    private static void showHelp() {
        System.out.println("Uso:    java -jar certificado.jar [--soft/--token/--help/--licencia]");
        System.out.println("                                 [--soft]   [path-al-cert]         [output-msg] [output-error]");
        System.out.println("                                 [--token]  [config-con-dll] [pin] [output-msg] [output-error]");
        System.out.println();
        System.out.println("        --help      -h                       Muestra \u00e9sta ayuda");
        System.out.println("        --licencia  -l                       Muestra la licencia del programa");
        System.out.println("        --soft      -s    path-al-cert       Ubicaci\u00f3n del certificado x509 en formato PEM");
        System.out.println("        --token     -t    conf-con-dll       Ubicaci\u00f3n del programa PKCS#11 (.dll) del Token utilizado");
        System.out.println();
        System.out.println("        output-msg    OPCIONAL               Documento de salida de mensajes, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("        output-error  OPCIONAL*              Documento de salida de errores, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("                                             *Opcional s\u00f3lo si output-msg est\u00e1 establecido");
    }

    private static X509Certificate getCert(String info, int isToken, String outputMsg) throws IOException, DsCOD.CustomException {
        if (isToken == 0) {
            DsCOD genEnvel = new DsCOD(info, isToken, outputMsg);
            return DsCOD.signingCertificate_;
        }
        return null;
    }

    private static X509Certificate getCert(String info, int isToken, String pin, String outputMsg) throws Exception, DsCOD.CustomException {
        if (isToken == 1) {
            DsCOD genEnvel = new DsCOD(info, isToken, outputMsg);
            genEnvel.selectSignatureKey(pin);
            return DsCOD.signingCertificate_;
        }
        return null;
    }

    private static String getExecutionPath(Class c) {
        URL rootPath = c.getProtectionDomain().getCodeSource().getLocation();
        String URI2 = rootPath.toString().substring(6);
        String[] currentPath = URI2.split("certificado.jar");
        currentPath[0] = currentPath[0].replaceAll("%20", " ");
        return currentPath[0];
    }

    public static void main(String[] args) throws Exception, DsCOD.CustomException {
        Path file;
        int isToken = -1;
        String outputMsg = null;
        String cert_begin = "-----BEGIN CERTIFICATE-----\n";
        String end_cert = "-----END CERTIFICATE-----";
        String startup = "DS-COD versi\u00f3n 1.2.2\nDerechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\nCopyright \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\nDS-COD carece totalmente de garant\u00eda. Este es Software Libre y\nest\u00e1 permitido redistribuirlo bajo ciertas condiciones.\nAgregue \"--licencia\" al comando para m\u00e1s detalles.\n";
        System.out.println(startup);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        if (Integer.parseInt(version) != 8) {
            System.out.println("Error: Por favor ejecute con java 8");
        }
        String licencia = " Derechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n Este es un Software Libre; como tal redistribuirlo y/o modificarlo est\u00e1\n permitido, siempre y cuando se haga bajo los t\u00e9rminos y condiciones de la\n Licencia P\u00fablica General GNU publicada por la Free Software Foundation,\n ya sea en su versi\u00f3n 2 \u00f3 cualquier otra de las posteriores a la misma.\n\n Este \"Programa\" se distribuye con la intenci\u00f3n de que sea \u00fatil, sin\n embargo carece de garant\u00eda, ni siquiera tiene la garant\u00eda impl\u00edcita de\n tipo comercial o inherente al prop\u00f3sito del mismo \"Programa\". Ver la\n Licencia P\u00fablica General GNU para m\u00e1s detalles.\n\n Se debe haber recibido una copia de la Licencia P\u00fablica General GNU con\n este \"Programa\", si este no fue el caso, favor de escribir a la Free\n Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,\n MA 02110-1301 USA.\n\n Autor: Mart\u00edn Iv\u00e1n R\u00edos\n Correo electr\u00f3nico: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Empresa: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n\n                                  --------------------------------------------------------------\n\n Copyright \u00a9 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n This program is free software; you can redistribute it and/or modify\n it under the terms of the GNU General Public License as published by\n the Free Software Foundation; either version 2 of the License, or\n (at your option) any later version.\n\n This program is distributed in the hope that it will be useful,\n but WITHOUT ANY WARRANTY; without even the implied warranty of\n MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n GNU General Public License for more details.\n\n You should have received a copy of the GNU General Public License along\n with this program; if not, write to the Free Software Foundation, Inc.,\n 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n\n Author: Mart\u00edn Iv\u00e1n R\u00edos\n E-mail: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Company: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n";
        if (args.length == 0) {
            CertInfo.showHelp();
            System.exit(0);
        }
        switch (args[0]) {
            case "-s": {
                isToken = 0;
                break;
            }
            case "--soft": {
                isToken = 0;
                break;
            }
            case "-t": {
                isToken = 1;
                break;
            }
            case "--token": {
                isToken = 1;
                break;
            }
            case "--licencia": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-l": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-h": {
                CertInfo.showHelp();
                System.exit(0);
                break;
            }
            case "--help": {
                CertInfo.showHelp();
                System.exit(0);
                break;
            }
            default: {
                CertInfo.showHelp();
                System.exit(0);
            }
        }
        if (isToken == 1) {
            if (args.length < 2) {
                CertInfo.showHelp();
                System.exit(0);
            }
            if (args.length > 3) {
                outputMsg = args[3];
                file = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                System.out.println("Salida en " + args[3]);
            }
            if (args.length > 4) {
                file = Paths.get(args[4], new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                PrintStream err = new PrintStream(new FileOutputStream(args[4]));
                System.setErr(err);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                System.out.println("Errores en " + args[4]);
            }
            String dll = new Scanner(new File(args[1])).useDelimiter("\\Z").next();
            if (!args[1].contains(".txt")) {
                throw new DsCOD.CustomException("#### \n" + dll + " no es un archivo de configuraci\u00f3n valido");
            }
            X509Certificate signingCertificate_ = CertInfo.getCert(dll, isToken, args[2], outputMsg);
            if (outputMsg != null) {
                System.out.println("Salida en " + outputMsg);
                Path file2 = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file2);
                Files.createFile(file2, new FileAttribute[0]);
                List<String> lines = Collections.singletonList(signingCertificate_.toString());
                Files.write(file2, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                byte[] derCert = signingCertificate_.getEncoded();
                String pemCertPre = Base64.encodeBase64String((byte[])derCert);
                String pemCert = cert_begin + pemCertPre + end_cert;
                String pem = CertInfo.getExecutionPath(CertInfo.class) + "pem.pem";
                Path pemPath = Paths.get(pem, new String[0]);
                Files.deleteIfExists(pemPath);
                Files.createFile(pemPath, new FileAttribute[0]);
                List<String> pemLines = Collections.singletonList(pemCert);
                Files.write(pemPath, pemLines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(signingCertificate_);
            }
        } else if (isToken == 0) {
            String fileName;
            if (args.length > 3) {
                file = Paths.get(args[3], new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                PrintStream err = new PrintStream(new FileOutputStream(args[3]));
                System.setErr(err);
                List<String> linesTmp = Collections.singletonList("####");
                Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                System.out.println("Errores en " + args[3]);
            }
            if (args.length > 2) {
                outputMsg = args[2];
                file = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file);
                Files.createFile(file, new FileAttribute[0]);
                System.out.println("Salida en " + args[2]);
            }
            if (!(fileName = args[1]).contains(".pem")) {
                throw new DsCOD.CustomException("#### \n" + fileName + " no es un certificado valido");
            }
            X509Certificate signingCertificate_ = CertInfo.getCert(fileName, isToken, outputMsg);
            if (outputMsg != null) {
                System.out.println("Salida en " + outputMsg);
                Path file3 = Paths.get(outputMsg, new String[0]);
                Files.deleteIfExists(file3);
                Files.createFile(file3, new FileAttribute[0]);
                List<String> lines = Collections.singletonList(signingCertificate_.toString());
                Files.write(file3, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                byte[] derCert = signingCertificate_.getEncoded();
                String pemCertPre = Base64.encodeBase64String((byte[])derCert);
                String pemCert = cert_begin + pemCertPre + end_cert;
                String pem = CertInfo.getExecutionPath(CertInfo.class) + "pem.pem";
                Path pemPath = Paths.get(pem, new String[0]);
                Files.deleteIfExists(pemPath);
                Files.createFile(pemPath, new FileAttribute[0]);
                List<String> pemLines = Collections.singletonList(pemCert);
                Files.write(pemPath, pemLines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(signingCertificate_);
            }
        }
    }
}

